Bird = class()

function Bird:created(radius)
    self.radius = radius
    self.entity.body2d:circle(radius)
    self.entity.body2d.mass = 1.
    self.manager = scene.main:findEntity("Manager"):get(GameManager)
    self.entity.collisionBegan2d = function()
        if not self.manager.gameOver then
            local instance = sound.play(asset.sfx_hit)
            table.insert(allSounds, instance)
        end
        self.manager.gameOver = true
    end
    self.colors = {
    strokeC = color(192, 191, 146),
    fillC = color(211, 209, 187)}
    
    self.shouldReset = true
    self.shouldAppear = false
end

function Bird:fixedUpdate()

end

function Bird:update()
    self.entity.worldPosition = vec3(0, self.entity.worldPosition.y, 0)
    if self.manager.isRestarting then
        tween(self.colors):to{strokeC = color(192, 191, 146, 0), fillC = color(211, 209, 187, 0)}:time(0.25):to{strokeC = color(192, 191, 146, 0), fillC = color(211, 209, 187, 0)}:time(0.25):onComplete(function() self.shouldReset = true; self.shouldAppear = true 
        self.entity.worldPosition = vec3(0, 0, 0)
        end)
    end
    if self.shouldAppear then
        tween(self.colors):to{strokeC = color(192, 191, 146), fillC = color(211, 209, 187)}:time(0.25):onComplete(function()
            self.manager.canStart = true    
        end)
        self.shouldAppear = false
    end
end

function Bird:draw()
    style.push().fill(self.colors.fillC).stroke(self.colors.strokeC).strokeWidth(0.3 * scene.main.pixelsPerUnit).ellipseMode(RADIUS).sortOrder(-7)
    lineWidth = style.strokeWidth()
    ellipse(0, 0, self.radius - (lineWidth /2.) / scene.main.pixelsPerUnit)
    style.pop()
end
